<?php

namespace RachidLaasri\LaravelInstaller\Helpers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class EnvironmentManager
{
    /**
     * @var string
     */
    private $envPath;

    /**
     * @var string
     */
    private $envExamplePath;

    /**
     * Set the .env and .env.example paths.
     */
    public function __construct()
    {
        $this->envPath = base_path('.env');
        $this->envExamplePath = base_path('.env.example');
    }

    /**
     * Get the content of the .env file.
     *
     * @return string
     */
    public function getEnvContent()
    {
        if (! file_exists($this->envPath)) {
            if (file_exists($this->envExamplePath)) {
                copy($this->envExamplePath, $this->envPath);
            } else {
                touch($this->envPath);
            }
        }

        return file_get_contents($this->envPath);
    }

    /**
     * Get the the .env file path.
     *
     * @return string
     */
    public function getEnvPath()
    {
        return $this->envPath;
    }

    /**
     * Get the the .env.example file path.
     *
     * @return string
     */
    public function getEnvExamplePath()
    {
        return $this->envExamplePath;
    }

    /**
     * Save the edited content to the .env file.
     *
     * @param Request $input
     * @return string
     */
    public function saveFileClassic(Request $input)
    {
        $message = trans('installer_messages.environment.success');

        try {
            file_put_contents($this->envPath, $input->get('envConfig'));
        } catch (Exception $e) {
            $message = trans('installer_messages.environment.errors');
        }

        return $message;
    }

    /**
     * Save the form content to the .env file.
     *
     * @param Request $request
     * @return string
     */
    public function saveFileWizard(Request $request)
    {
        $results = trans('installer_messages.environment.success');

        $envFileData =
        'APP_NAME=\''.$request->app_name."'\n".
        'APP_ENV='.'local'."\n".
        'APP_KEY='.'base64:2VU8pLtRXkeyciDFnFipQ5zsuceyUppjXFo++eUrLfU='."\n".
        'APP_DEBUG='.'false'."\n".
        'APP_URL='.$request->app_url."\n\n".
        'Environment='.'live'."\n\n".
        'DB_CONNECTION='.$request->database_connection."\n".
        'DB_HOST='.$request->database_hostname."\n".
        'DB_PORT='.$request->database_port."\n".
        'DB_DATABASE='.$request->database_name."\n".
        'DB_USERNAME='.$request->database_username."\n".
        'DB_PASSWORD='.$request->database_password."\n\n".
        'BROADCAST_DRIVER='.'log'."\n".
        'CACHE_DRIVER='.'file'."\n".
        'FILESYSTEM_DRIVER='.'local'."\n".
        'QUEUE_CONNECTION='.'sync'."\n\n".
        'SESSION_DRIVER='.'file'."\n".
        'SESSION_LIFETIME='.'120'."\n".
        'MEMCACHED_HOST='.'127.0.0.1'."\n".
        'REDIS_HOST='.'127.0.0.1'."\n".
        'REDIS_PASSWORD='.'null'."\n".
        'REDIS_PORT='.'6379'."\n\n".
        'MAIL_MAILER='.'smtp'."\n".
        'MAIL_HOST='.'smtp.gmail.com'."\n".
        'MAIL_PORT='.'587'."\n".
        'MAIL_USERNAME='.'MAIL_USERNAME'."\n".
        'MAIL_PASSWORD='.'MAIL_PASSWORD'."\n".
        'MAIL_ENCRYPTION='.'tls'."\n".
        'MAIL_FROM_ADDRESS='.'hello@example.com'."\n".
        'MAIL_FROM_NAME='.'"${APP_NAME}"'."\n\n".
        'FACEBOOK_CLIENT_ID='.'XXXXXXXXXXXX'."\n".
        'FACEBOOK_CLIENT_SECRET='.'XXXXXXXXXXXX'."\n".
        'FACEBOOK_CALLBACK_URL='.'https://your-domain.com/login/google/callback'."\n\n".
        'ASSETSPATHURL='.'storage/app/public/'."\n";

        try {
            file_put_contents($this->envPath, $envFileData);
        } catch (Exception $e) {
            $results = trans('installer_messages.environment.errors');
        }

        return $results;
    }
}
